﻿using Spectral1.DATA_ACCESS;
using Spectral1_VBClassLibrary;
using System;
using static Spectral1_VBClassLibrary.DataSet_Spectral;

namespace Spectral1.BUSINESS_LOGIC
{
    public class c_body_resonance_filter
    {
        #region "================ DECLARATIONS ========================"
        static CodeGen_DS_Spectral _CGS;
        static DA_Spectral _DASP;
        private Int32 _body_resonance_filter_id = 0;

        #endregion

        #region "================ PROPERTIES ========================"
        public Int32 body_resonance_filter_id { get { return _body_resonance_filter_id; } }

        private body_resonance_filterRow r
        {
            get
            {
                return _CGS.Table_body_resonance_filter.GetRow(_body_resonance_filter_id);
            }
        }

        public string body_resonance_filter_guid8
        {
            get
            {
                if (r == null)
                {
                    return "";
                }
                else
                {
                    return r.body_resonance_filter_guid8;
                }
            }
            set
            {
                if (r != null)
                { r.body_resonance_filter_guid8 = value; }
            }
        }

        public string body_resonance_filter_name
        {
            get
            {
                if (r == null)
                {
                    return "";
                }
                else
                {
                    return r.body_resonance_filter_name;
                }
            }
            set
            {
                if (r != null)
                { r.body_resonance_filter_name = value; }
            }

        }

        #endregion

        #region "================ METHODS ========================"
        public c_body_resonance_filter(CodeGen_DS_Spectral CGS, DA_Spectral DASP, Int32 body_resonance_filter_id)
        {
            _CGS = CGS;
            _DASP = DASP;
            _body_resonance_filter_id = body_resonance_filter_id;
        }

        public Double GetFilterScalingFactor()
        {
            Double max_value = 0;
            UInt16 lu;
            int b;
            body_resonance_filter_bandRow r;
            for (b = 0; b < DA_Spectral.max_body_resonance_filter_bands; b++)
            {
                r = _CGS.Table_body_resonance_filter_band.GetRow(body_resonance_filter_id, b);
                if (r != null)
                {
                    lu = (UInt16)(r.level);
                    if (lu > max_value) { max_value = lu; }
                }
            }

            Double scaling_factor;
            if (max_value == 0)
            {
                scaling_factor = 1;
            }
            else
            {
                scaling_factor = 65535 / max_value;
            }

            return scaling_factor;
        }

        #endregion
    }
}
